﻿var projects = {
    context: $(".v-projects"),
    catiOnly: $("#CatiOnly").val(),
    datatable: null,
    dataTableSelectedFilter: 0,
    treeview: null,
    autoLoginRowId: "0_0_0",
    projectWasAutoSelected: false,
    projectAutoSelectionOccured:false,
    treeExpanded: true,
    treeExpandedByDepth: [],
    currentRootNodeId: null,  
    previousRootNodeId: null,
    nbProjectPerPage: 10,
    initializeDataTable: function(folderId, parentId, folderType) {
        this.datatable = $(".h-projectsTable").a4datatable({
            ajaxAction: a4.getAgentAction("SelectProjects.aspx", "GetModulesList"),
            ajaxParams: { "folderId": folderId, "parentId": parentId, "folderType": folderType, "filterType": 0 },
            columns: [
                { "Name": "Id", "Data": "Id", "Title": "Id", "Key": true, "HideInSelector": true, "Visible": false },
                { "Name": "ProjectName", "Title": resources.ProjectName, "Data": "ProjectName" },
                { "Name": "ProntoModuleName", "Title": resources.TelephonyModule, "Data": "ProntoModuleName" },
                { "Name": "CatiName", "Title": resources.CatiModule, "Data": "CatiName", "HideInSelector": false },
                { "Name": "Group", "Title": resources.Group, "Data": "Group", "Type": "numeric", "Editable": EditableGroupCondition },
                { "Name": "Priority", "Title": resources.ColumnPriority, "Data": "Priority" },
                { "Name": "ProntoName", "Title": resources.ProntoName, "Data": "ProntoName" }
            ],
            //stateKey: "Projects",
            deferLoad: true,
            allowRowSelection:true, //"[Priority]> 0",
            rememberRowSelection: true,
            showSelectAll: false,
            displayLength: projects.nbProjectPerPage,
            scrollY: '70vh',
            scrollCollapse: true,
            showPagination: true,
            paging: true,
            lengthMenu:[10,25,50],
            toolBarItems: [
            ],
            contextMenuItems: [
            ],
            contextMenuClick: function(event, data) {
            },
            toolBarClick: function(event, data) {
            },
            quickFilter: {
                "DisplayMode": "buttons",
                "IncludeAll": projects.catiOnly == "0",
                "Items": [
                    { "Label": resources.NoPriority, "AjaxParams": { "filterType": 1 }, "DisplayCondition": projects.catiOnly == "0" },
                    { "Label": resources.Priority, "AjaxParams": { "filterType": 2 }, "DisplayCondition": projects.catiOnly == "0" }
                ]
            },
            multiEdit: GroupEditable,
            rowsUpdated: function (event, data) {
                a4.callServerMethod(a4.getAgentAction("SelectProjects.aspx", "EditGroups"), { modules: data.rows }, function (result) {
                    var resultObj = JSON.parse(result.d);
                    if (resultObj.ResultCode == -1) {
                        Dialog.showAlert({}, resultObj.UserMessage);
                    }
                    data.multiEditSaveCallback();
                    projects.updateSelectedRowsGroup(data.rows);
                });
            },
            selectRow: function (event, data) {
                projects.setSelectedRows(data);
            },
            rowCreated: function (event, data) {
                projects.setCreatedRows(data);
            },
            applyFilter: function (event, data) {
                if (data.filter != undefined) {
                    projects.dataTableSelectedFilter = data.filter.AjaxParams.filterType;
                }
                else {
                    projects.dataTableSelectedFilter = 0;
                }
            }
        });
    },
    updateSelectedRowsGroup: function (updatedRows) {
        var selectedRows = projects.datatable.a4datatable("getSelectedItems");
        _.each(selectedRows, function (selectedRow) {
            var match = _.find(updatedRows, function (updatedRow) { return selectedRow.Id == updatedRow.Id; })
            if (match) {
                selectedRow.Group = match.Group;
            }
        });
    },
    getTreeViewCollapseLevel: function (level) {
        var treeViewCollapseLevel;
        switch (level) {
            case "1":
                treeViewCollapseLevel = [false,false];
                break;
            case "2":
                treeViewCollapseLevel = [false, false];
                break;
            case "3":
                treeViewCollapseLevel = [true, false];
                break;
            default:
                treeViewCollapseLevel = [];
                break;
        }

        return treeViewCollapseLevel;
    },
    initializeTreeView: function() {
        projects.treeview = $(".h-projectstree").a4listview({
            ajaxAction: a4.getAgentAction("SelectProjects.aspx", "GetProjectsTree"),
            expanded: projects.treeExpanded,
            expandedByDepth: projects.treeExpandedByDepth,
            //stateKey: "Projects",
            draw: function(event, data) {
                var folder = data.selectedNode;
                var folderId = folder ? (folder.Id || 0) : -1;
                var parentId = folder ? (folder.ParentId || null) : -1;
                var folderType = folder ? (folder.FolderType || 0) : 0;

                if (projects.datatable) {
                    projects.datatable.a4datatable("option", "ajaxParams", { "folderId": folderId, "parentId": parentId, "folderType": folderType, "filterType": projects.dataTableSelectedFilter });
                    projects.datatable.a4datatable("refresh",true,true);
                } else {
                    projects.initializeDataTable(folderId, parentId, folderType);
                }

                if (projects.selectedNodeId != undefined) { // selectedNodeId is set dynamically by backend SelectProject>ProcessAutoLogin
                    $(".h-projectstree").a4listview("selectSpecificNode", projects.selectedNodeId);
                }
                else {
                    $(".h-projectstree").a4listview("selectFirstRootNode");
                }
                $(".v-tableContainer").toggleClass("right-panel", data.count > 1);
                $(this).toggle(data.count > 1);

                // When no data have been found for the tree, the datatable is loade by a call to refresh datatable since the normal 
                // data load is triggered by the automatic selection of the first node of the tree.
                // Note that the tree is expected to be empty when agent is assigned to a workflow. 
                if (data.count == 0) { 
                    projects.datatable.a4datatable("refresh", true);
                }
            },
            selectNode: function (event, data) {
                // Tracking current and previous root node to manage module reset on pronto changes
                if (data.node.ParentId === null) {
                    projects.previousRootNodeId = projects.currentRootNodeId;
                    projects.currentRootNodeId = data.node.Id;
                }

                var parentNode = projects.treeview.a4listview("getParentNode", data.node);
                projects.setColumnVisibility("ProntoModuleName", data.node, parentNode);
                projects.setColumnVisibility("ProntoName", data.node, parentNode);
                projects.setColumnVisibility("Priority", data.node, parentNode);
                projects.setColumnVisibility("Group", data.node, parentNode);

                if (data.node.Id === 0 || data.node.ParentId === 0) { // Special node CATI Module
                    projects.datatable.a4datatable("hideQuickFilter");
                    projects.datatable.a4datatable("option", "ajaxParams", { "folderId": data.node.Id, "parentId": data.node.ParentId, "folderType": data.node.FolderType, "filterType": 3 });
                }
                else {
                    projects.datatable.a4datatable("showQuickFilter");
                    projects.datatable.a4datatable("option", "ajaxParams", { "folderId": data.node.Id, "parentId": data.node.ParentId, "folderType": data.node.FolderType, "filterType": projects.dataTableSelectedFilter });
                }

                // When choosing a root node, which mean a pronto node, it is assume that the user want to reset all the previously selected module 
                // from the other pronto node
                if (data.node.ParentId === null && projects.currentRootNodeId !== projects.previousRootNodeId) {
                    projects.datatable.a4datatable("resetOtherSelectedRows", null, null);
                }
                projects.datatable.a4datatable("refresh", true);
                
                // When autologin is used and more than one projects match the provided autologin project id, 
                // the last one in the list is auto selected, but in this situation, the datatable must show the last page.
                if (projects.projectWasAutoSelected != undefined && projects.projectWasAutoSelected === true) {
                    if (projects.selectedModuleIndex) {
                        var overflow = (projects.selectedModuleIndex % projects.nbProjectPerPage > 0) ? 1 : 0;
                        var pageNum = (Math.floor(projects.selectedModuleIndex / projects.nbProjectPerPage) + overflow) - 1;
                        projects.datatable.a4datatable("setPage", pageNum);
                    }
                }
            },
            clearTable: function (event, data) {
                projects.datatable.a4datatable("option", "ajaxParams", { "folderId": -2, "parentId": null, "folderType": -2 });
                projects.datatable.a4datatable("clear");
            },
            unselectNode: function (event, data) {
                // Do nothing for now
            },
            actionButtons: [
            ],
            actionButtonClick: function(event, data) {
            },
            icons: null
        });
    },
    setColumnVisibility: function (columnName, node, parentNode) {
        var isVisible = true;

        switch (columnName) {
            case "ProntoModuleName":
            case "ProntoName":
                if (node.Id === 0 || node.ParentId === 0) { // Special node CATI Module
                    isVisible = false;
                }
                break;

            case "Priority":
                if (node.ProntoDialerType == 'Manual' || parentNode.ProntoDialerType === 'Manual' || // TCPA - no priority
                    node.Id === 0 || node.ParentId === 0) {                                          // Special node CATI Module
                    isVisible = false;
                }
                break;

            case "Group":
                if ( (node.ParentId !== 0)  && // ParentId 0 mean CATI Module - do not consider dialer type for CATI Module
                     (node.ProntoDialerType == 'Manual' || parentNode.ProntoDialerType === 'Manual') ) { // TCPA - no group
                    isVisible = false;
                }
                break;
        }
        projects.datatable.a4datatable("toggleColumn", columnName, isVisible);
    },
    bindEvents: function () {
        $("#btnAccept").on("click", function () {
            projects.accept();
        });
        
        $("#btnCancel").on("click", function () {
            projects.cancel();
        });
        
        $("#btnClear").on("click", function () {
            projects.reset();
        });
    },
    setCreatedRows: function (data) {

        if (projects.projectWasAutoSelected && projects.autoLoginRowId != "0_0_0" && projects.autoLoginRowId == data.data.Id && projects.projectAutoSelectionOccured == false) {
            $('.selectRow', data.row).attr("checked", "checked").prop('checked', true);
            projects.projectAutoSelectionOccured = true;
            projects.datatable.a4datatable("setSelectedRow", data.row, data.data);
        }
        
        var selectedItems = projects.datatable.a4datatable("getSelectedItems");
        if (selectedItems.length == 0) return;
        
        var createdRow = data.data;
        var createdNode = projects.datatable.a4datatable("getNode", data.index);
        var isChecked = $('.selectRow', data).is(":checked");
        var isPriority = createdRow.Priority;

        $.each(selectedItems, function(i, e) {
            var rowData = e;
            if (createdRow.Id == rowData.Id) return true;

            if (isPriority ) {
                if ((createdRow.Priority == 0) || (rowData.Priority > 0 && createdRow.ProntoId != rowData.ProntoId) || (createdRow.ProjectId == rowData.ProjectId)) {
                    $('.selectRow', createdNode).attr("disabled", "disabled").prop("disabled", true);
                }
            } else {
                if ((createdRow.Priority > 0) || (createdRow.Priority == 0 && createdRow.ProntoId != rowData.ProntoId)) {
                    $('.selectRow', createdNode).attr("disabled", "disabled").prop("disabled", true);
                }
            }
            return true;
        });
        projects.setEnableAcceptButton();
    },
    setSelectedRows: function (data) {
       
        var selectedRow = data.data;
        var isChecked = data.isChecked;
        var isPrioritySelected = selectedRow.Priority;

        $.each(projects.datatable.a4datatable("getNodes"), function(i, e) {
            var rowData = projects.datatable.a4datatable("getNodeData", i);

            if (selectedRow.Id == rowData.Id && isPrioritySelected) {
                return true;
            } else if (selectedRow.Id == rowData.Id && !isPrioritySelected) {
                if (projects.datatable.a4datatable("getSelectedItemsCount") > 1)
                    projects.datatable.a4datatable("resetOtherSelectedRows", data.row[0], data.data);
                return true;
            }

            if (isPrioritySelected > 0 && AgentAssignmentEnable == false ) {
                if ((rowData.Priority == 0) || (rowData.Priority > 0 && selectedRow.ProntoId != rowData.ProntoId) || (selectedRow.ProjectId == rowData.ProjectId)) {
                    if (isChecked)
                        $('.selectRow', e).attr("disabled", "disabled").prop("disabled", true);
                    else if (projects.datatable.a4datatable("getSelectedItemsCount") == 0 || (selectedRow.ProjectId == rowData.ProjectId && selectedRow.ProntoId == rowData.ProntoId))
                        $('.selectRow', e).removeAttr("disabled").prop("disabled", false);
                }
            } else {
                if ($('.selectRow', e).is(":checked")) {
                    $('.selectRow', e).removeAttr("checked").prop("checked", false);
                    projects.datatable.a4datatable("setSelectedRow", e, rowData);
                    $('.selectRow', e).removeAttr("disabled").prop("disabled", false);
                }

                if ((rowData.Priority > 0) || (selectedRow.Priority == 0 && selectedRow.ProntoId != rowData.ProntoId)) {
                    if (isChecked)
                        $('.selectRow', e).attr("disabled", "disabled").prop("disabled", true);
                    else {
                        $('.selectRow', e).removeAttr("disabled").prop("disabled", false);
                    }
                }
            }
            return true;
        });
        projects.setEnableAcceptButton();
    },
    setEnableAcceptButton:function () {
        var btn = $("#btnAccept");
        if (btn != null) {

            var isEditing = projects.datatable.a4datatable("getEditingState");
            if (typeof isEditing != "boolean")
                isEditing = false;

            var selectedItemsCount = projects.datatable.a4datatable("getSelectedItemsCount");
            projects.enableButton(btn, (selectedItemsCount > 0 && !isEditing) ? true : false);
        }
    },
    ButtonPosition: function () {
        var btn = $("#btnAccept");
        if (btn != null && !projects.projectWasAutoSelected) {
            projects.enableButton(btn, false);
        }

        btn = $("#btnCancel");
        if (btn != null && !projects.projectWasAutoSelected) $("#btnCancel").hide();
        return;
    },
    
    initialize: function () {
        
        projects.treeExpandedByDepth = projects.getTreeViewCollapseLevel($("#hiddenTreeViewCollapseLevel").val()),
        projects.catiOnly = $("#CatiOnly").val();

        processProntoStationParms(null);

      
        window.history.go(1);

        if (window.Event && window.document.captureEvents)
            window.document.captureEvents(Event.MOUSEUP);
        window.document.oncontextmenu = function (e) { return noContextMenuVoxcoAgent(e); };
        window.document.onkeydown = function (e) { return onKeyDownVoxcoAgent(e); };
        window.document.onmousedown = function (e) { return norightclickVoxcoAgent(e); };
        window.document.onkeypress = function (e) { return onKeyPressVoxcoAgent(e); };
        window.document.onkeyup = function (e) { return onKeyUpVoxcoAgent(e); };

        //US2329: If a module was auto selected by using the autologin and projectid parameters we set this control variable to true. 
        
        try
        {
            var closesentinel = gClassManager.getCloseSentinelFrame();
            if (closesentinel != null && closesentinel != undefined) {
                closesentinel.closeCurrentProject(true);
            }

            var _assignment = gClassManager.getAgentAssignmentClass();
            if (_assignment != undefined || _assignment != null) {

                if (_assignment.isProjectButtonRequired() == false) {

                    var tr = document.getElementById('btnProjectsTr');
                    if (tr != null && tr != undefined) { tr.style.display = 'none'; }
                    enableTbButton('btnProjects', false);
                }
            }

            var crossdomain = gClassManager.getCrossDomainClass();
            if (crossdomain != undefined || crossdomain != null) {
                crossdomain.hideAlert();
            }
               

        }
        catch( e )
        {

        }

       
        debug("SelectProjects.OnPageLoad> loading select page");
        var url = $("#hiddenUrl").val();
        if (url != undefined && url != null && url.length > 0) {
            // redirecting

         
            debug("SelectProjects.OnPageLoad> redirect has been detected to " + url);
            setTimeout("projects.redirectIntWeb('" + url + "');", 1000);
            return;
        }


        var expires = "";
        var date = new Date();
        date.setTime(date.getTime() + (24 * 60 * 60 * 1000));
        expires = "; expires=" + date.toGMTString();
        document.cookie = "InCallback=false" + expires + "; path=/";
        document.cookie = "Dialed=false" + expires + "; path=/";
        document.cookie = "HasFiche=false" + expires + "; path=/";

        assignBackgroundForButton("PROJECT");

        var toolbar = gClassManager.getToolbar();
        var closesentinel = gClassManager.getCloseSentinelFrame();

        if (closesentinel != null && closesentinel.reDirecting != undefined)
            closesentinel.reDirecting(false);

        if (toolbar != null) {
            if (toolbar.refreshButtons != undefined)
                toolbar.refreshButtons();
            else {
                if (toolbar.UpdateTbOnSignedOff != undefined) {
                    toolbar.UpdateTbOnSignedOff(_STATUS_NOTSIGNEDON);
                }
            }
        }
        projects.ButtonPosition();
    },

    redirectIntWeb: function (url) {
        if (url != null) {
            //
            // DE9813: Nettoyage de la session HTTP avant le redirect. Avec les anciennes versions , la fermeture de la session HTTP etait fait trop tôt et
            // et provoquait des erreurs a la presentation des pages HTML
            //

            debug("SelectProjects.redirectIntWeb> the redirect is proceeding to cati server " + url, false);
            gClassManager.getAgentAssignmentClass().HttpRedirect("http.redirect", url);

        }
    },
    loadIframe: function (iframeName, url) {

        var $iframe = gClassManager.getFrameSet().getFrameForJQuery(iframeName);// $('#' + iframeName);
        if ($iframe.length) {
            $iframe.attr('src', url);
            return false;
        }
        return true;
    },
    redirectToUrl: function (url) {
        if (url != null) {
            var f0 = gClassManager.getCloseSentinelFrame();
            if (f0 != null && f0.reDirecting != undefined) {
                debug("SelectProjects.redirectToCCAuthenticated> the redirect is proceeding to " + url, false);
                f0.reDirecting(true);
                projects.loadIframe("f2",url);
            }
        }
    },
    enableButton: function(btn,enable) {
        if (btn != null) {
            if (enable) {
                btn.removeAttr("disabled").prop("disabled", false);
                btn.addClass("primary");
                btn.removeClass("disabled");
            } else {
                btn.attr("disabled", "disabled").prop('disabled', true);
                btn.addClass("disabled");
                btn.removeClass("primary");
            }
        }
    },
    accept: function () {
        // Disable Accept button
        projects.enableButton($("#btnAccept"), false);
        projects.enableButton($("#btnClear"), false);


        var toolbar = gClassManager.getToolbar();
        var AgentAssignment = gClassManager.getAgentAssignmentClass();
        if (typeof AgentAssignment == "object")
            AgentAssignment.DisableAssignment();

        //
        //  On puplie l'evenement publisheronprojectselection pour les custom callback ( inhouse )
        //
        
        var closesentinel = gClassManager.getCloseSentinelFrame();
        if (typeof closesentinel == "object" && typeof closesentinel.IntWeb == "object") {
            closesentinel.publishEvent(closesentinel.publisheronprojectselection);      
        }

        
        // Disable preferences button
        var toolbar = gClassManager.getToolbar();
        if (toolbar != null) toolbar.enableTbButton('btnPref', false);

        iCommon.callServerMethod("SelectProjects.aspx", "Accept", { modules: projects.datatable.a4datatable("getSelectedItems") },
            function (result) {
                var config = gClassManager.getConfigManager();
                if (result.d !== undefined) {
                    if (result.d.HasPendingUser == true)
                        setTimeout('projects.doValidateForceLogin();', 500);
                    else if (result.d.Result !== "") {
                        $("#lblErr").val(result.d.Result);
                        $("#lblErr").text(result.d.Result);
                        projects.enableButton($("#btnAccept"), true);
                        projects.enableButton($("#btnClear"), true);
                    } else {
                      
                        if (result.d.RedirectIntwebUrl !== null && result.d.RedirectIntwebUrl.length !== 0)
                        {
                            gClassManager.getAgentAssignmentClass().showRedirectUrl(result.d.RedirectIntwebUrl);
                            setTimeout("projects.redirectIntWeb('" + result.d.HiddenUrl + "');", 1000);
                        }

                        if (result.d.RedirectToUrl !== "") projects.redirectToUrl(result.d.RedirectToUrl);
                    }
                    return true;
                }
            }, function (xhr, msg, e) {
                $("#lblErr").val(msg);
                $("#lblErr").text(msg);
                projects.enableButton($("#btnAccept"), true);
                projects.enableButton($("#btnClear"), true);
                return false;
            });
    },
    reset: function () {
        projects.refreshContent();
        projects.setEnableAcceptButton();
    },
    cancel: function () {
        iCommon.callServerMethod("SelectProjects.aspx", "Cancel", { modules: projects.datatable.a4datatable("getSelectedItems") },
            function(result) {
                if (result.d !== undefined && result.d !== "") projects.redirectToUrl(result.d);
            }, function(xhr, msg, e) {
                return false;
            });
    },
    setForcedLogin: function (forced) {
        var additionnalSetting = {};
        additionnalSetting.async = false;
        iCommon.callServerMethod("SelectProjects.aspx", "SetForcedLogin", { forcedLogin: forced }, null, null, additionnalSetting);
    },
    doValidateForceLogin: function () {
        var str = "";
        _assignment = gClassManager.getAgentAssignmentClass();
        if (_assignment != undefined && _assignment != null) {
            str = resources.User + " ";
            str += _assignment.getAgentName();
            str += " " + resources.IsAlreadyLogin + "; ";
        }
        str += resources.AreYouSureToRelogin;
        error("Relogin required: " + str);

        var properties = { onClick: projects.onLoginConfirmation, cancel: getTranslatedString("STR_Cancel") };
        DialogBox.showDialog(properties, str);
    },

    onLoginConfirmation: function ( bConfirm ) {
        projects.setForcedLogin(bConfirm);
        if( bConfirm == true )
            projects.accept();
    },

    doAlertSessionLost: function () {
      
        DialogBox.showAlert(resources.SessionLost);
        return false;
    },
    refreshContent: function () {
        projects.datatable.a4datatable("resetOtherSelectedRows", null, null);
        projects.datatable.a4datatable("resetSearch");

        projects.treeview.a4listview("refresh");
        if (!projects.treeExpanded) {
            _.each($(".h-projectstree ul").children(), function (n) {
                var k = n;
            });
        }
    },
    showBusyBox: function() {
        a4.showBusyBox();
    },
    hideBusyBox: function() {
        a4.hideBusyBox();
    },

    _info: function( message ){
        try {
            Logger._info(message);
        }
        catch (e) {

        }
    },
   
    _error: function( message )
    {
        try {
            Logger._error(message);
        }
        catch(e){

        }

    }
   
};

$(document).ready(function () {

    var closesentinelframe = gClassManager.getCloseSentinelFrame();
    var shareframe = gClassManager.getSharedFrame();
    var toolbar = gClassManager.getToolbar();
    if (redirectInfo != undefined) {
        setTimeout(function () {
         
            var config = gClassManager.getConfigManager();
            var _txt = document.getElementById('lblErr');
            if (_txt != null) {
                _txt.style.color = 'red';
                _txt.innerHTML = toolbar.getVAResourceValue('STR_REDIRECT') + " " + redirectInfo.RedirectIntwebUrl;
            }
        }, 1000);

        setTimeout("projects.redirectIntWeb('" + redirectInfo.HiddenUrl + "');", 2000);
    }
    else {
        if ($(".v-projects").length > 0) {
            projects.initialize();
            projects.initializeTreeView();
            projects.bindEvents();
        }
    }

    var properties = { dialogtitle: resources.dialogtitle, alerttitle: resources.alerttitle };
    Dialog.init(properties);
    Logger.getLogSetting();
   
});